	% Example N=9
	clear all
	close all
	clc
	% Lattice Wave Digital Filter
	fs = 16; lw = 2; fn = 'times'; 	
	
	WcT = 0.55*pi; WsT = 0.6*pi; Amax = 0.1;Amin = 65;
	
	N = CA_ORDER_Z(WcT, WsT, Amax, Amin)
	N = 9;			% We MUST select an odd order
	
	[G, Z, R_ZEROS, P, WsnewT] = CA_POLES_Z(WcT, WsT, Amax, Amin, N);	
	% Compute the adaptor coefficients
	[Godd, Podd, Geven, Peven] = SORT_LATTICE_POLES_LP_Z(P);
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(Podd, Peven);
	subplot('position', [0.1 0.4 0.88 0.5]);
	wT = linspace(0, pi, 512); 
	
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	%	PLOT_ATT_Z(wT, Att)
	axis([0 pi 0 80]);
	
	a1 = alfa_odd(1);
	a2 = alfa_odd(2);
	a3 = alfa_odd(3);
	a4 = alfa_odd(4);
	a5 = alfa_odd(5);
	a6 = alfa_even(1);
	a7 = alfa_even(2);
	a8 = alfa_even(3);
	a9 = alfa_even(4);
	c0=1;c1 = 1/8;c2=1;c3=1/2;c4=1/4;c5=1/2;c6 = 1/2;c7=1/4;c8=1/4;
	format short
	% v1
	a11 = a1;
	a12 = c1*(a1+1)*(1-a2)/c0;
	a13 = 0;
	a14 = c3*(a1+1)*(a4-1)*a2/c0;
	a15 = 0;
	a16 = 0;
	a17 = 0;
	a18 = 0;
	a19 = 0;
	% v21
	a21 = 0;
	a22 = -a3*a2;
	a23 = c2*(1-a3);
	a24 = c3*(a2+1)*(a4-1)*a3/c1;
	a25 = 0;
	a26 = 0;
	a27 = 0;
	a28 = 0;
	a29 = 0;
	% v22
	a31 = 0;
	a32 = (1+a3)*a2/c2;
	a33 = a3;
	a34 = -c3*(a4-1)*(1+a3)*(a2+1)/(c2*c1);
	a35 = 0;
	a36 = 0;
	a37 = 0;
	a38 = 0;
	a39 = 0;
	% v31
	a41 = 0;
	a42 = 0;
	a43 = 0;
	a44 = -a5*a4;
	a45 = c4*(1-a5);
	a46 = 0;
	a47 = 0;
	a48 = 0;
	a49 = 0;	
	% v32
	a51 = 0;
	a52 = 0;
	a53 = 0;
	a54 = (a5+1)*a4/c4;
	a55 = a5;
	a56 = 0;
	a57 = 0;
	a58 = 0;
	a59 = 0;
	% v41
	a61 = 0;
	a62 = 0;
	a63 = 0;
	a64 = 0;
	a65 = 0;
	a66 = -a7*a6;
	a67 = c6*(1-a7);
	a68 = c7*(a8-1)*(a6+1)*a7/c5;
	a69 = 0;
	% v42
	a71 = 0;
	a72 = 0;
	a73 = 0;
	a74 = 0;
	a75 = 0;
	a76 = (a7+1)*a6/c6;
	a77 = a7;
	a78 = c7*(1-a8)*(a7+1)*(a6+1)/(c6*c5);
	a79 = 0;
	% v51
	a81 = 0;
	a82 = 0;
	a83 = 0;
	a84 = 0;
	a85 = 0;
	a86 = 0;
	a87 = 0;
	a88 = -a9*a8;
	a89 = c8*(1-a9);
	% v52
	a91 = 0;
	a92 = 0;
	a93 = 0;
	a94 = 0;
	a95 = 0;
	a96 = 0;
	a97 = 0;
	a98 = (a9+1)*a8/c8;
	a99 = a9;
	
	D = (a8*a6-a4*a2*a1)/2;
	cm1 = (1+a1)*a4*a2/(2*c0);
	cm2 = (a2+1)*a4*a3/(2*c1);
	cm3 = -(a3+1)*(a2+1)*a4/(2*c2*c1);
	cm4 = -(a4+1)*a5/(2*c3);
	cm5 = (a5+1)*(a4+1)/(2*c4*c3);
	cm6 = (a6+1)*a8*a7/(2*c5);
	cm7 = -(a7+1)*(a6+1)*a8/(2*c6*c5);
	cm8 = -(a8+1)*a9/(2*c7);
	cm9 = (a9+1)*(a8+1)/(2*c8*c7);
	C = [cm1 cm2 cm3 cm4 cm5 cm6 cm7 cm8 cm9];
	
	b1 = c0*(1-a1);
	b2 = c1*(a2-1)*a1;
	b3 = 0;
	b4 = c3*(1-a4)*a2*a1;
	b5 = 0;
	b6 = c5*(1-a6);
	b7 = 0;
	b8 = c7*(a8-1)*a6;
	b9 = 0;
	
	B = [b1 b2 b3 b4 b5 b6 b7 b8 b9]';
	A = [
	a11 a12 a13 a14 a15 a16 a17 a18 a19
	a21 a22 a23 a24 a25 a26 a27 a28 a29 
	a31 a32 a33 a34 a35 a36 a37 a38 a39
	a41 a42 a43 a44 a45 a46 a47 a48 a49
	a51 a52 a53 a54 a55 a56 a57 a58 a59
	a61 a62 a63 a64 a65 a66 a67 a68 a69
	a71 a72 a73 a74 a75 a76 a77 a78 a79
	a81 a82 a83 a84 a85 a86 a87 a88 a89
	a91 a92 a93 a94 a95 a96 a97 a98 a99]';
	
	x = 1; v = zeros(9,1);
	for n = 1:22
		h(n) = C*v + D*x;
		v = A*v + B*x;		
		x = 0; 
	end
	figure(1)
	PLOT_IMPULSE_RESPONSE_Z(h)	
	
	figure(2)
	[G, Z, P] = IMPULSE_2_P_Z(h, 9);
	wT = [0:0.001:pi];
	
	Att = PZ_2_ATT_Z(G, Z, P, wT); 	
	subplot('position', [0.08 0.4 0.88 0.5]);
	plot(wT, Att-min(Att),'linewidth', 2);
	axis([0 pi 0 80]);
	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', fn,'FontSize', fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);	
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};;
	xtick(ax,lab); grid on;
	
	figure(3)
	PLOT_PZ_Z(Z, P)
	
	% Noise	
	for n = 1:40
		G=A'*G*A + C'*C;
	end
	G=A'*G*A + C'*C;
	sigma = 0
	for n = 1:9
		sigma = sigma+ G(n,n);
	end
	sigma
	
